(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10176,        358]*)
(*NotebookOutlinePosition[     11020,        385]*)
(*  CellTagsIndexPosition[     10976,        381]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(\( (*\ Degenerate\ kernel\ k \((x, s)\) = Sinh \((x + s)\), \n\t
      solved\ by\ least - squares\ method, \n\t
      Example\ 2.2 \( \(.2\)\(.\)\)\ \ *) \)\(\n\)\(Integrate[
        Sinh[x + s], {s, \ \(-1\), 1}] // Simplify\)\)\)], "Input"],

Cell[BoxData[
    \(2\ Sinh[1]\ Sinh[x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \(2.3504023872876028`\ Sinh[x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[s*Sinh[x + s], {s, \ \(-1\), 1}] // Simplify\)], "Input"],

Cell[BoxData[
    \(\(2\ Cosh[x]\)\/\[ExponentialE]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \(0.7357588823428847`\ Cosh[x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[s^2*Sinh[x + s], {s, \ \(-1\), 1}] // Simplify\)], "Input"],

Cell[BoxData[
    \(\(\((\(-5\) + \[ExponentialE]\^2)\)\ Sinh[x]\)\/\[ExponentialE]\)], \
"Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \(0.8788846226018334`\ Sinh[x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ Writing\ \[Psi]1[x]\ for\ \[Psi]1[x_] \[Psi]1[x, \[Lambda]], \ 
      and\ so\ on\ *) \n\(\[Psi]0[
          x_] := \(-0.87888462260183342`\)\ Sinh[x];\)\), "\n", 
    \(\(\[Psi]1[x_] := 1 - 2.35040238728760275`\ Sinh[x];\)\), "\n", 
    \(\(\[Psi]2[x_] := x - 0.735758882342884668`\ Cosh[x];\)\), "\n", 
    \(\(\[Psi]3[x_] := x^2 - 0.87888462260183342`\ Sinh[x];\)\), "\n", 
    \(a11 = Integrate[\[Psi]1[s]*\[Psi]1[s], \ {s, \ \(-1\), 1}]\)}], "Input"],

Cell[BoxData[
    \(6.493706808549595`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a12 = Integrate[\[Psi]1[s]*\[Psi]2[s], \ {s, \ \(-1\), 1}]\)], "Input"],

Cell[BoxData[
    \(\(-3.45865886705355`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a13 = Integrate[\[Psi]1[s]*\[Psi]3[s], \ {s, \ \(-1\), 1}]\)], "Input"],

Cell[BoxData[
    \(2.3469958876870365`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a21 = Integrate[\[Psi]2[s]*\[Psi]1[s], \ {s, \ \(-1\), 1}]\)], "Input"],

Cell[BoxData[
    \(\(-3.45865886705355`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a22 = Integrate[\[Psi]2[s]*\[Psi]2[s], \ {s, \ \(-1\), 1}]\)], "Input"],

Cell[BoxData[
    \(2.1896921607243836`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a23 = Integrate[\[Psi]2[s]*\[Psi]3[s], \ {s, \ \(-1\), 1}]\)], "Input"],

Cell[BoxData[
    \(\(-1.293294335267746`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a31 = Integrate[\[Psi]3[s]*\[Psi]1[s], \ {s, \ \(-1\), 1}]\)], "Input"],

Cell[BoxData[
    \(2.3469958876870365`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a32 = Integrate[\[Psi]3[s]*\[Psi]2[s], \ {s, \ \(-1\), 1}]\)], "Input"],

Cell[BoxData[
    \(\(-1.293294335267746`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a33 = Integrate[\[Psi]3[s]*\[Psi]3[s], \ {s, \ \(-1\), 1}]\)], "Input"],

Cell[BoxData[
    \(1.0283245461504094`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a10 = \(-Integrate[\[Psi]1[s]*\[Psi]0[s], \ {s, \ \(-1\), 
            1}]\)\)], "Input"],

Cell[BoxData[
    \(\(-1.6803292210203715`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a20 = \(-Integrate[\[Psi]2[s]*\[Psi]0[s], \ {s, \ \(-1\), 
            1}]\)\)], "Input"],

Cell[BoxData[
    \(0.646647167633873`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a30 = \(-Integrate[\[Psi]3[s]*\[Psi]0[s], \ {s, \ \(-1\), 
            1}]\)\)], "Input"],

Cell[BoxData[
    \(\(-0.6283245461504091`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m = {{a11, \ a12, \ a13}, \n\t\t{a21, \ a22, \ a23}, \n\t\t{a31, \ 
          a32, \ a33}}\)], "Input"],

Cell[BoxData[
    \({{6.493706808549595`, \(-3.45865886705355`\), 
        2.3469958876870365`}, {\(-3.45865886705355`\), 
        2.1896921607243836`, \(-1.293294335267746`\)}, {2.3469958876870365`, \
\(-1.293294335267746`\), 1.0283245461504094`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b = {a10, \ a20, \ a30}\)], "Input"],

Cell[BoxData[
    \({\(-1.6803292210203715`\), 
      0.646647167633873`, \(-0.6283245461504091`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[m, b]\)], "Input"],

Cell[BoxData[
    \({\(-0.551607844395267`\), \(-0.7514722672964212`\), \
\(-0.29716107749058995`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ since\ c3 = 1, \ 
      we\ take\ 2  
        x2\ system\ *) \n\(m1 = {{6.49370680854959481`, \
\(-3.45865886705355052`\)}, {\(-3.45865886705355052`\), 
            2.1896921607243831`}};\)\), "\n", 
    \(\(b1 = {\(-1.68032922102037129`\), 0.646647167633872932`};\)\), "\n", 
    \(LinearSolve[m1, b1]\)}], "Input"],

Cell[BoxData[
    \({\(-0.6393164124042765`\), \(-0.7144977906225286`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(tilde\[CurlyPhi][x_]\  := \ 
        x^2 - 0.714497790622528583`\ x - 
          0.639316412404276501`;\)\), "\[IndentingNewLine]", 
    \(Table[tilde\[CurlyPhi][x], \ {x, \ \(-1. \), \ 1. , \ 0.1}]\)}], "Input"],

Cell[BoxData[
    \({1.075181378218252`, 0.8137315991559992`, 0.5722818200937465`, 
      0.35083204103149335`, 
      0.14938226196924065`, \(-0.032067517093012254`\), \
\(-0.19351729615526508`\), \(-0.334967075217518`\), \
\(-0.45641685427977086`\), \(-0.5578666333420237`\), \
\(-0.6393164124042765`\), \(-0.7007661914665294`\), \(-0.7422159705287823`\), \
\(-0.7636657495910351`\), \(-0.7651155286532879`\), \(-0.7465653077155407`\), \
\(-0.7080150867777937`\), \(-0.6494648658400465`\), \(-0.5709146449022993`\), \
\(-0.472364423964552`\), \(-0.3538142030268051`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ For\ values\ of\ \[Alpha]\ and\ \[Beta], \ 
      see\ the\ end\ of\ this\ file\ *) \n\(exact[x_] := 
        x^2 - 0.682083640587590522`*Sinh[x] - 
          0.554827434856053347`*Cosh[x];\)\), "\n", 
    \(Table[exact[x], \ {x, \ \(-1. \), \ 1. , \ 0.1}]\)}], "Input"],

Cell[BoxData[
    \({0.945442038192854`, 0.7150546222294085`, 0.5037169610129916`, 
      0.3110153333360809`, 
      0.1365223669563742`, \(-0.020207238688259577`\), \
\(-0.15964116919747495`\), \(-0.2822741759631256`\), \
\(-0.38863302780748676`\), \(-0.4792817830626812`\), \
\(-0.5548274348560533`\), \(-0.6159259861014058`\), \(-0.6632890149966503`\), \
\(-0.6976907967375825`\), \(-0.719976052724284`\), \(-0.7310684048168155`\), \
\(-0.7319796192532319`\), \(-0.7238197327461595`\), \(-0.7078081621033121`\), \
\(-0.6852859085607621`\), \(-0.657728978974038`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ To\ check\ values\ of\ alpha\ and\ beta, \ 
      as\ given\ in\ CRC\ Book\ p . \ 587\ *) \)\(\n\)\(integral = 
      Integrate[
          Sinh[x + 
                s]*\((s^2 + \[Alpha]*Sinh[s] + \[Beta]*
                  Cosh[s])\), {s, \(-1\), 1}] // Simplify\)\)\)], "Input"],

Cell[BoxData[
    \(1\/2\ \((\[Alpha]\ Cosh[
              x]\ \((\(-2\) + Sinh[2])\) + \((\(-\(10\/\[ExponentialE]\)\) + 
                2\ \[ExponentialE] + \[Beta]\ \((2 + Sinh[2])\))\)\ Sinh[
              x])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{\[Alpha]*\((\(-1\) - 4\ E^2 + 
                  E^4)\)/\((4\ E^2)\) == \ \[Beta], \n\t\t\[Beta]*\((\(-1\) + 
                    4\ E^2 + E^4)\)/\((4\ E^2)\) + \((E^2 - 5)\)/
              E == \[Alpha]}, \ {\[Alpha], \[Beta]}]\)], "Input"],

Cell[BoxData[
    \({{\[Alpha] \[Rule] \(-\(\(16\ \[ExponentialE]\^3\ \((\(-5\) + \
\[ExponentialE]\^2)\)\)\/\(1 - 
                  34\ \[ExponentialE]\^4 + \[ExponentialE]\^8\)\)\), \[Beta] \
\[Rule] \(-\(\(4\ \[ExponentialE]\ \((\(-5\) + \[ExponentialE]\^2)\)\ \((\(-1\
\) - 4\ \[ExponentialE]\^2 + \[ExponentialE]\^4)\)\)\/\(1 - 
                  34\ \[ExponentialE]\^4 + \[ExponentialE]\^8\)\)\)}}\)], \
"Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \({{\[Alpha] \[Rule] \(-0.6820836405875905`\), \[Beta] \[Rule] \
\(-0.5548274348560533`\)}}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{Automatic, 70}, {46, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 265, 4, 75, "Input"],
Cell[2007, 57, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2097, 63, 37, 1, 27, "Input"],
Cell[2137, 66, 62, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2236, 72, 87, 1, 27, "Input"],
Cell[2326, 75, 65, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2428, 81, 37, 1, 27, "Input"],
Cell[2468, 84, 62, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2567, 90, 89, 1, 27, "Input"],
Cell[2659, 93, 99, 2, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2795, 100, 37, 1, 27, "Input"],
Cell[2835, 103, 62, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2934, 109, 481, 7, 107, "Input"],
Cell[3418, 118, 52, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3507, 124, 91, 1, 27, "Input"],
Cell[3601, 127, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3694, 133, 91, 1, 27, "Input"],
Cell[3788, 136, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3878, 142, 91, 1, 27, "Input"],
Cell[3972, 145, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4065, 151, 91, 1, 27, "Input"],
Cell[4159, 154, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4249, 160, 91, 1, 27, "Input"],
Cell[4343, 163, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4437, 169, 91, 1, 27, "Input"],
Cell[4531, 172, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4621, 178, 91, 1, 27, "Input"],
Cell[4715, 181, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4809, 187, 91, 1, 27, "Input"],
Cell[4903, 190, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4993, 196, 109, 2, 27, "Input"],
Cell[5105, 200, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5200, 206, 109, 2, 27, "Input"],
Cell[5312, 210, 52, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5401, 216, 109, 2, 27, "Input"],
Cell[5513, 220, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5608, 226, 123, 2, 59, "Input"],
Cell[5734, 230, 262, 4, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6033, 239, 56, 1, 27, "Input"],
Cell[6092, 242, 113, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6242, 249, 50, 1, 27, "Input"],
Cell[6295, 252, 114, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6446, 259, 342, 7, 91, "Input"],
Cell[6791, 268, 86, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6914, 274, 235, 4, 59, "Input"],
Cell[7152, 280, 584, 9, 71, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7773, 294, 296, 5, 75, "Input"],
Cell[8072, 301, 582, 9, 71, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8691, 315, 308, 6, 91, "Input"],
Cell[9002, 323, 230, 4, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9269, 332, 268, 4, 59, "Input"],
Cell[9540, 338, 420, 7, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9997, 350, 37, 1, 27, "Input"],
Cell[10037, 353, 123, 2, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

